/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.event.ClientEvent;
import noppes.npcs.api.mixin.client.gui.IGuiScreenMixin;
import noppes.npcs.client.gui.GuiBoundarySetting;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcMiniWindow;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiTextArea;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiMenuSideButton;
import noppes.npcs.client.gui.util.IGuiMenuTopButton;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcCheckBox;
import noppes.npcs.client.gui.util.IGuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcMiniWindow;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiTextArea;
import noppes.npcs.client.gui.util.IKeyListener;
import noppes.npcs.client.gui.util.IMouseListener;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Keyboard;

public class GuiNPCInterface
extends GuiScreen
implements IEditNPC,
ICustomScrollListener,
ISubGuiListener {
    public static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation RESOURCE_SLOT = new ResourceLocation("customnpcs", "textures/gui/slot.png");
    public static final ResourceLocation MENU_BUTTON = new ResourceLocation("customnpcs", "textures/gui/menubutton.png");
    public static final ResourceLocation MENU_SIDE_BUTTON = new ResourceLocation("customnpcs", "textures/gui/menusidebutton.png");
    public static final ResourceLocation MENU_TOP_BUTTON = new ResourceLocation("customnpcs", "textures/gui/menutopbutton.png");
    public static final ResourceLocation ANIMATION_BUTTONS = new ResourceLocation("customnpcs", "textures/gui/animation/buttons.png");
    public static final ResourceLocation ANIMATION_BUTTONS_SLOTS = new ResourceLocation("customnpcs", "textures/gui/animation/button_slots.png");
    public boolean closeOnEsc = false;
    public boolean hoverMiniWin = false;
    public boolean drawDefaultBackground = false;
    protected boolean hasArea = false;
    public int guiLeft;
    public int guiTop;
    public int mouseX;
    public int mouseY;
    public int xSize;
    public int ySize;
    public int widthTexture = 0;
    public int heightTexture = 0;
    public int borderTexture = 4;
    public float bgScale = 1.0f;
    public float translateZ = 0.0f;
    public String title = "";
    protected final List<String> hoverText = new ArrayList<String>();
    public ResourceLocation background = null;
    public EntityNPCInterface npc;
    public EntityPlayerSP player;
    protected GuiButton field_146290_a;
    public SubGuiInterface subgui;
    protected final List<int[]> line = new ArrayList<int[]>();
    protected final List<IComponentGui> components = new ArrayList<IComponentGui>();
    protected final Map<Integer, IGuiNpcButton> buttons = new ConcurrentHashMap<Integer, IGuiNpcButton>();
    protected final Map<Integer, IGuiNpcLabel> labels = new ConcurrentHashMap<Integer, IGuiNpcLabel>();
    protected final Map<Integer, IGuiCustomScroll> scrolls = new ConcurrentHashMap<Integer, IGuiCustomScroll>();
    protected final Map<Integer, IGuiMenuSideButton> sideButtons = new ConcurrentHashMap<Integer, IGuiMenuSideButton>();
    protected final Map<Integer, IGuiNpcSlider> sliders = new ConcurrentHashMap<Integer, IGuiNpcSlider>();
    protected final Map<Integer, IGuiNpcTextField> textFields = new ConcurrentHashMap<Integer, IGuiNpcTextField>();
    protected final Map<Integer, IGuiMenuTopButton> topButtons = new ConcurrentHashMap<Integer, IGuiMenuTopButton>();
    protected final Map<Integer, IGuiNpcMiniWindow> miniWindows = new ConcurrentHashMap<Integer, IGuiNpcMiniWindow>();

    public GuiNPCInterface(INpc npc) {
        this(npc instanceof EntityNPCInterface ? (EntityNPCInterface)npc : null);
    }

    public GuiNPCInterface() {
        this((EntityNPCInterface)null);
    }

    public GuiNPCInterface(EntityNPCInterface npc) {
        this.npc = npc;
        this.xSize = 200;
        this.ySize = 222;
        this.field_146297_k = Minecraft.func_71410_x();
        this.player = this.field_146297_k.field_71439_g;
        this.field_146296_j = this.field_146297_k.func_175599_af();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        if (this.npc == null) {
            this.npc = NoppesUtilServer.getEditingNpc((EntityPlayer)this.player);
        }
    }

    public static void fill(int left, int top, int right, int bottom, float zLevel, int startColor, int endColor) {
        float alpha_0 = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float red_0 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float green_0 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float blue_0 = (float)(startColor & 0xFF) / 255.0f;
        float alpha_1 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float red_1 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float green_1 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float blue_1 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(red_1, green_1, blue_1, alpha_1).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(red_0, green_0, blue_0, alpha_0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(red_0, green_0, blue_0, alpha_0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(red_1, green_1, blue_1, alpha_1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    protected List<String> getHoverText() {
        return this.hoverText;
    }

    @Override
    public void buttonEvent(@Nonnull IGuiNpcButton button, int mouseButton) {
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        if (!(guibutton instanceof IGuiNpcButton)) {
            return;
        }
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.buttonEvent((IGuiNpcButton)guibutton);
        }
        if (this.hoverMiniWin) {
            return;
        }
        if (this.subgui != null) {
            this.subgui.buttonEvent((IGuiNpcButton)guibutton);
        } else {
            this.buttonEvent((IGuiNpcButton)guibutton);
        }
    }

    @Override
    public void add(IComponentGui component) {
        this.components.add(component);
        if (component instanceof GuiNpcTextArea) {
            this.hasArea = true;
        }
    }

    @Override
    public IComponentGui get(int id) {
        for (IComponentGui component : this.components) {
            if (component.getID() != id) continue;
            return component;
        }
        return id < this.components.size() ? this.components.get(id) : null;
    }

    public IComponentGui get(int id, Class<?> classType) {
        for (IComponentGui component : this.components) {
            if (component.getID() != id || !component.getClass().isAssignableFrom(classType)) continue;
            return component;
        }
        return id < this.components.size() ? this.components.get(id) : null;
    }

    public void addButton(GuiNpcButton button) {
        this.addButton((IGuiNpcButton)button);
    }

    @Override
    public void addButton(IGuiNpcButton button) {
        this.buttons.put(button.getID(), button);
        this.add(button);
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, int textureX, int textureY, ResourceLocation texture) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, textureX, textureY, texture);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, int val, String ... display) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, val, display);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String label) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, label);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String label, boolean enabled) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, label, enabled);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, int width, int height, String[] display, int val) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, width, height, display, val);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, String label) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, label);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcButton addButton(int id, int x, int y, String[] display, int val) {
        GuiNpcButton button = new GuiNpcButton(id, x, y, display, val);
        this.addButton((IGuiNpcButton)button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, int width, int height, String trueLabel, String falseLabel) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, width, height, trueLabel, falseLabel);
        this.addButton(button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, int width, int height, String trueLabel, String falseLabel, boolean select) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, width, height, trueLabel, falseLabel, select);
        this.addButton(button);
        return button;
    }

    @Override
    public IGuiNpcCheckBox addCheckBox(int id, int x, int y, String trueLabel, String falseLabel, boolean select) {
        GuiNpcCheckBox button = new GuiNpcCheckBox(id, x, y, trueLabel, falseLabel, select);
        this.addButton(button);
        return button;
    }

    public void addLabel(GuiNpcLabel label) {
        this.addLabel((IGuiNpcLabel)label);
    }

    @Override
    public void addLabel(IGuiNpcLabel label) {
        this.labels.put(label.getID(), label);
        this.add(label);
    }

    @Override
    public IGuiNpcLabel addLabel(int id, Object label, int x, int y, int color) {
        GuiNpcLabel iLabel = new GuiNpcLabel(id, label, x, y, color);
        this.addLabel((IGuiNpcLabel)iLabel);
        return iLabel;
    }

    @Override
    public IGuiNpcLabel addLabel(int id, Object label, int x, int y) {
        GuiNpcLabel iLabel = new GuiNpcLabel(id, label, x, y);
        this.addLabel((IGuiNpcLabel)iLabel);
        return iLabel;
    }

    public void addScroll(GuiCustomScroll scroll) {
        this.addScroll((IGuiCustomScroll)scroll);
    }

    @Override
    public void addScroll(IGuiCustomScroll scroll) {
        if (scroll instanceof GuiScreen) {
            ((GuiScreen)scroll).func_146280_a(this.field_146297_k, scroll.getWidth(), scroll.getHeight());
        }
        scroll.setParent(this);
        this.scrolls.put(scroll.getID(), scroll);
        this.add(scroll);
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, int scrollId) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, scrollId);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, boolean setSearch, int id) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, setSearch, id);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    @Override
    public IGuiCustomScroll addScroll(ICustomScrollListener parent, int id, boolean isMultipleSelection) {
        GuiCustomScroll scroll = new GuiCustomScroll(parent, id, isMultipleSelection);
        this.addScroll((IGuiCustomScroll)scroll);
        return scroll;
    }

    public void addSideButton(GuiMenuSideButton slider) {
        this.addSideButton((IGuiMenuSideButton)slider);
    }

    @Override
    public void addSideButton(IGuiMenuSideButton slider) {
        this.sideButtons.put(slider.getID(), slider);
        this.add(slider);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.addSlider((IGuiNpcSlider)slider);
    }

    @Override
    public void addSlider(IGuiNpcSlider slider) {
        this.sliders.put(slider.getID(), slider);
        this.add(slider);
    }

    public void addTextField(GuiNpcTextField textField) {
        this.addTextField((IGuiNpcTextField)textField);
    }

    @Override
    public void addTextField(IGuiNpcTextField textField) {
        this.textFields.put(textField.getID(), textField);
        this.add(textField);
    }

    @Override
    public void addTopButton(IGuiMenuTopButton button) {
        this.topButtons.put(button.getID(), button);
        this.add(button);
    }

    public void addMiniWindow(GuiNpcMiniWindow miniwindows) {
        this.addMiniWindow((IGuiNpcMiniWindow)miniwindows);
    }

    @Override
    public void addMiniWindow(IGuiNpcMiniWindow miniwindows) {
        this.miniWindows.put(miniwindows.getID(), miniwindows);
        miniwindows.resetButtons();
        this.add(miniwindows);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
    }

    @Override
    public void close() {
        this.displayGuiScreen(null);
        this.field_146297_k.func_71381_h();
        this.save();
    }

    public void displayGuiScreen(GuiScreen gui) {
        ClientEvent.NextToGuiCustomNpcs event = new ClientEvent.NextToGuiCustomNpcs(this.npc, this, gui);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.returnGui == null || event.isCanceled()) {
            return;
        }
        this.field_146297_k.func_147108_a(event.returnGui);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void doubleClicked() {
    }

    public void func_146276_q_() {
        super.func_146276_q_();
    }

    @Override
    public void drawNpc(Entity entity, int x, int y, float zoomed, int rotation, int vertical, int mouseFocus) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        if (!(entity instanceof EntityLivingBase)) {
            mouseFocus = 0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179109_b((float)(this.guiLeft + x), (float)(this.guiTop + y), (float)50.0f);
        float scale = 1.0f;
        if ((double)entity.field_70131_O > 2.4) {
            scale = 2.0f / entity.field_70131_O;
        }
        GlStateManager.func_179152_a((float)(-30.0f * scale * zoomed), (float)(30.0f * scale * zoomed), (float)(30.0f * scale * zoomed));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).field_70761_aq : entity.field_70177_z;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).field_70759_as : entity.field_70177_z;
        float f6 = mouseFocus == 0 || mouseFocus == 2 ? 0.0f : (float)(this.guiLeft + x - this.mouseX);
        float f7 = mouseFocus == 0 || mouseFocus == 3 ? 0.0f : (float)(this.guiTop + y) - 50.0f * scale * zoomed - (float)this.mouseY;
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = rotation;
        }
        GlStateManager.func_179114_b((float)((float)(-Math.atan(f6 / 400.0f) * 20.0)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.atan(f7 / 40.0f) * 20.0)), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70177_z = (float)(Math.atan(f6 / 80.0f) * 40.0 + (double)rotation);
        entity.field_70125_A = (float)(-Math.atan(f7 / 40.0f) * 20.0);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70761_aq = rotation;
            ((EntityLivingBase)entity).field_70759_as = entity.field_70177_z;
        }
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        if (mouseFocus != 0 && vertical != 0) {
            GlStateManager.func_179137_b((double)0.0, (double)(1.0 - Math.cos((double)vertical * 3.14 / 180.0)), (double)0.0);
            GlStateManager.func_179114_b((float)vertical, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.field_146297_k.func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70761_aq = f2;
            ((EntityLivingBase)entity).field_70760_ar = f2;
        }
        entity.field_70177_z = f3;
        entity.field_70126_B = f3;
        entity.field_70125_A = f4;
        entity.field_70127_C = f4;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70759_as = f5;
            ((EntityLivingBase)entity).field_70758_at = f5;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    @Override
    public void drawNpc(int x, int y) {
        this.drawNpc((Entity)this.npc, x, y, 1.0f, 0, 0, 1);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawMainScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawMainScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.translateZ != 0.0f) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.translateZ);
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int x = mouseX;
        int y = mouseY;
        if (this.subgui != null) {
            x = 0;
            y = 0;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawDefaultBackground && this.subgui == null) {
            this.func_146276_q_();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.background != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)this.bgScale, (float)this.bgScale, (float)this.bgScale);
            this.field_146297_k.func_110434_K().func_110577_a(this.background);
            if (this.widthTexture != 0 && this.heightTexture != 0) {
                int maxCol = ValueUtil.correctInt((int)Math.ceil((float)this.xSize / (float)(this.widthTexture - 2 * this.borderTexture)), 2, 10);
                int maxRow = ValueUtil.correctInt((int)Math.ceil((float)this.ySize / (float)(this.heightTexture - 2 * this.borderTexture)), 2, 10);
                int tileWidth = this.xSize / maxCol;
                int tileHeight = this.ySize / maxRow;
                int lastTileWidth = this.xSize - tileWidth * (maxCol - 1);
                int lastTileHeight = this.ySize - tileHeight * (maxRow - 1);
                int uOffset = (this.widthTexture - 2 * this.borderTexture - tileWidth) / 2;
                int uMax = this.widthTexture - lastTileWidth;
                int vOffset = (this.heightTexture - 2 * this.borderTexture - tileHeight) / 2;
                int vMax = this.heightTexture - lastTileHeight;
                for (int col = 0; col < maxCol; ++col) {
                    for (int row = 0; row < maxRow; ++row) {
                        this.func_73729_b(col * tileWidth, row * tileHeight, col == 0 ? 0 : (col == maxCol - 1 ? uMax : uOffset), row == 0 ? 0 : (row == maxRow - 1 ? vMax : vOffset), col == maxCol - 1 ? lastTileWidth : tileWidth, row == maxRow - 1 ? lastTileHeight : tileHeight);
                    }
                }
            } else if (this.xSize > 256) {
                this.func_73729_b(0, 0, 0, 0, 250, this.ySize);
                this.func_73729_b(250, 0, 256 - (this.xSize - 250), 0, this.xSize - 250, this.ySize);
            } else {
                this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
            }
            GlStateManager.func_179121_F();
        }
        this.postDrawBackground();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        if (!this.line.isEmpty()) {
            for (int[] ln : this.line) {
                if (ln == null || ln.length < 6) continue;
                GuiBoundarySetting.drawLine(ln[0], ln[1], ln[2], ln[3], ln[4], ln[5]);
            }
            this.line.clear();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, this.field_146295_m + 10, CustomNpcs.MainColor.getRGB());
        this.hoverMiniWin = false;
        for (IComponentGui component : new ArrayList<IComponentGui>(this.components)) {
            component.render(this, x, y, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!(component instanceof GuiNpcMiniWindow) || !((GuiNpcMiniWindow)component).hovered) continue;
            this.hoverMiniWin = true;
        }
        if (this.translateZ != 0.0f) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-this.translateZ));
        }
        super.func_73863_a(x, y, partialTicks);
        if (this.subgui != null) {
            this.subgui.func_73863_a(mouseX, mouseY, partialTicks);
        } else if (CustomNpcs.ShowDescriptions && !this.hoverText.isEmpty()) {
            this.drawHoveringText(new ArrayList<String>(this.hoverText), mouseX, mouseY, this.field_146289_q);
            RenderHelper.func_74518_a();
            this.hoverText.clear();
        }
    }

    public void postDrawBackground() {
    }

    public void elementClicked() {
        if (this.subgui != null) {
            this.subgui.elementClicked();
        }
    }

    @Override
    public IGuiTextArea getTextArea(int id) {
        for (IComponentGui component : this.components) {
            if (!(component instanceof IGuiTextArea) || component.getID() != id) continue;
            return (IGuiTextArea)component;
        }
        return null;
    }

    @Override
    public IGuiNpcButton getButton(int id) {
        return this.buttons.get(id);
    }

    @Override
    public int getEventButton() {
        return ((IGuiScreenMixin)((Object)this)).npcs$getEventButton();
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public IGuiNpcLabel getLabel(int id) {
        return this.labels.get(id);
    }

    @Override
    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    @Override
    public IGuiCustomScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    @Override
    public IGuiMenuSideButton getSideButton(int id) {
        return this.sideButtons.get(id);
    }

    @Override
    public IGuiNpcSlider getSlider(int id) {
        return this.sliders.get(id);
    }

    @Override
    public SubGuiInterface getSubGui() {
        if (this.hasSubGui() && this.subgui.hasSubGui()) {
            return this.subgui.getSubGui();
        }
        return this.subgui;
    }

    @Override
    public IGuiNpcTextField getTextField(int id) {
        return this.textFields.get(id);
    }

    @Override
    public IGuiMenuTopButton getTopButton(int id) {
        return this.topButtons.get(id);
    }

    @Override
    public IGuiNpcMiniWindow getMiniWindow(int id) {
        return this.miniWindows.get(id);
    }

    @Override
    public boolean hasSubGui() {
        return this.subgui != null;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcTextField.unfocus();
        if (this.subgui != null) {
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.func_73866_w_();
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.hasArea = false;
        this.hoverText.clear();
        this.components.clear();
        this.field_146292_n.clear();
        this.buttons.clear();
        this.topButtons.clear();
        this.sideButtons.clear();
        this.textFields.clear();
        this.labels.clear();
        this.scrolls.clear();
        this.sliders.clear();
        this.miniWindows.clear();
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public void initPacket() {
    }

    public boolean isInventoryKey(int i) {
        return i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }

    @Override
    public boolean isMouseHover(int mX, int mY, int px, int py, int pWidth, int pHeight) {
        return mX >= px && mY >= py && mX < px + pWidth && mY < py + pHeight;
    }

    /*
     * WARNING - void declaration
     */
    public void func_73869_a(char c, int i) {
        if (this.subgui != null) {
            this.subgui.func_73869_a(c, i);
            return;
        }
        for (IGuiNpcMiniWindow iGuiNpcMiniWindow : this.miniWindows.values()) {
            iGuiNpcMiniWindow.customKeyTyped(c, i);
        }
        if (this.hoverMiniWin) {
            return;
        }
        boolean active = false;
        for (IComponentGui component : this.components) {
            if (!(component instanceof GuiTextArea) || !((GuiTextArea)component).isActive()) continue;
            active = true;
            break;
        }
        boolean bl = active = active || GuiNpcTextField.isActive();
        if (this.subgui == null) {
            void var4_10;
            boolean bl2 = false;
            if (i == 56 || i == 184) {
                boolean bl3 = Keyboard.isKeyDown((int)35);
            } else if (i == 35) {
                boolean bl4;
                boolean bl5 = bl4 = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
            }
            if (var4_10 != false) {
                boolean bl6 = CustomNpcs.ShowDescriptions = !CustomNpcs.ShowDescriptions;
            }
        }
        if (this.closeOnEsc && (i == 1 || !active && this.isInventoryKey(i))) {
            this.close();
            return;
        }
        for (IGuiNpcTextField tf : new ArrayList<IGuiNpcTextField>(this.textFields.values())) {
            tf.customKeyTyped(c, i);
        }
        for (IComponentGui component : this.components) {
            if (!(component instanceof IKeyListener)) continue;
            ((IKeyListener)((Object)component)).customKeyTyped(c, i);
        }
        if (this.hasSubGui()) {
            return;
        }
        for (IGuiCustomScroll scroll : new ArrayList<IGuiCustomScroll>(this.scrolls.values())) {
            scroll.customKeyTyped(c, i);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.subgui != null) {
            this.subgui.func_73864_a(mouseX, mouseY, mouseButton);
            return;
        }
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.customMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.hoverMiniWin) {
            return;
        }
        for (IGuiNpcTextField tf : new ArrayList<IGuiNpcTextField>(this.textFields.values())) {
            if (!tf.isEnabled()) continue;
            tf.customMouseClicked(mouseX, mouseY, mouseButton);
        }
        ArrayList<GuiButton> allButtons = new ArrayList<GuiButton>();
        for (IComponentGui iComponentGui : this.components) {
            if (iComponentGui instanceof IMouseListener) {
                ((IMouseListener)((Object)iComponentGui)).mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (!(iComponentGui instanceof GuiButton)) continue;
            allButtons.add((GuiButton)iComponentGui);
        }
        this.mouseEvent(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            for (IGuiNpcButton iGuiNpcButton : this.buttons.values()) {
                if (!iGuiNpcButton.isHovered()) continue;
                this.buttonEvent(iGuiNpcButton, mouseButton);
                break;
            }
            return;
        }
        for (IGuiCustomScroll iGuiCustomScroll : new ArrayList<IGuiCustomScroll>(this.scrolls.values())) {
            iGuiCustomScroll.customMouseClicked(mouseX, mouseY, mouseButton);
        }
        for (GuiButton guiButton : allButtons) {
            GuiButton guiButton2;
            if (!guiButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guiButton, allButtons);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            this.field_146290_a = guiButton2 = event.getButton();
            this.field_146290_a.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(guiButton2);
            if (!this.equals(this.field_146297_k.field_71462_r)) break;
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), allButtons));
            break;
        }
    }

    public void mouseEvent(int mouseX, int mouseY, int mouseButton) {
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.mouseEvent(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        for (IGuiNpcMiniWindow mwin : this.miniWindows.values()) {
            mwin.customMouseReleased(mouseX, mouseY, mouseButton);
        }
        if (this.hoverMiniWin) {
            return;
        }
        if (this.field_146290_a != null && mouseButton == 0) {
            this.field_146290_a.func_146118_a(mouseX, mouseY);
            this.field_146290_a = null;
        }
    }

    public void func_146281_b() {
        GuiNpcTextField.unfocus();
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setBackground(String texture) {
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
        switch (texture) {
            case "bgfilled.png": {
                this.widthTexture = 256;
                this.heightTexture = 256;
                break;
            }
            case "companion_empty.png": {
                this.widthTexture = 172;
                this.heightTexture = 167;
                break;
            }
            case "extrasmallbg.png": {
                this.widthTexture = 176;
                this.heightTexture = 71;
                break;
            }
            case "largebg.png": {
                this.widthTexture = 192;
                this.heightTexture = 231;
                break;
            }
            case "menubg.png": {
                this.widthTexture = 256;
                this.heightTexture = 217;
                break;
            }
            case "smallbg.png": {
                this.widthTexture = 176;
                this.heightTexture = 222;
                break;
            }
            case "standardbg.png": {
                this.widthTexture = 256;
                this.heightTexture = 195;
            }
        }
    }

    @Override
    public void setHoverText(@Nullable List<String> newHoverText) {
        this.hoverText.clear();
        if (newHoverText != null && !newHoverText.isEmpty()) {
            this.hoverText.addAll(newHoverText);
        }
    }

    @Override
    public void setHoverText(@Nullable String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public void drawHoverText(String text, Object ... args) {
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        if (text == null) {
            if (!this.hoverText.isEmpty()) {
                this.drawHoveringText(new ArrayList<String>(this.hoverText), this.mouseX, this.mouseY, this.field_146289_q);
            }
            this.hoverText.clear();
            return;
        }
        this.setHoverText(text, args);
        if (!this.hoverText.isEmpty()) {
            this.drawHoveringText(new ArrayList<String>(this.hoverText), this.mouseX, this.mouseY, this.field_146289_q);
            this.hoverText.clear();
        }
    }

    @Override
    public INpc getNpc() {
        return this.npc;
    }

    @Override
    public void setNpc(INpc iNpc) {
        if (iNpc instanceof EntityNPCInterface) {
            this.npc = (EntityNPCInterface)iNpc;
        }
    }

    @Override
    public void setSubGui(SubGuiInterface gui) {
        this.subgui = gui;
        if (this.subgui != null) {
            this.subgui.setNpc(this.npc);
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.setParent(this);
            this.subgui.getParent().func_73866_w_();
        }
    }

    public void func_146280_a(@Nonnull Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.initPacket();
    }

    public void func_73876_c() {
        if (this.subgui != null) {
            this.subgui.func_73876_c();
        } else {
            for (IComponentGui component : this.components) {
                if (component instanceof GuiNpcTextField) {
                    ((GuiNpcTextField)component).updateScreen();
                }
                if (!(component instanceof GuiTextArea)) continue;
                ((GuiTextArea)component).updateScreen();
            }
            super.func_73876_c();
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
    }

    @Override
    public void addLine(int sX, int sY, int eX, int eY, int color, int size) {
        this.line.add(new int[]{sX, sY, eX, eY, color, size});
    }

    @Override
    public void closeMiniWindow(IGuiNpcMiniWindow miniWindow) {
        this.miniWindows.remove(miniWindow.getID());
    }

    @Override
    public void setMiniHoverText(int id, IComponentGui component) {
    }

    @Override
    public boolean hasArea() {
        return this.hasArea;
    }

    @Override
    public void drawWait() {
    }

    @Override
    public boolean hasHoverText() {
        return false;
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
    }
}

